%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculation of the thermal conductivity of a two phase system           %
% Weighted arithmetic mean                                                %
% Nelson Molina-Giraldo 2011                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function lm = Tcond_arithmetic(ls,lw,n)
lm = n*lw+(1-n)*ls;

% lm: thermal conductivity of the two phase system
% lw: thermal conductivity of the fluid phase
% ls: thermal conductivity of the solid phase
% n: porosity 